/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.websocket.Extension;

public class TyrusExtension
implements Extension,
Serializable {
    private static final transient Logger LOGGER = Logger.getLogger(TyrusExtension.class.getName());
    private final String name;
    private final ArrayList<Extension.Parameter> parameters;
    private static final long serialVersionUID = -3671075267907614851L;

    public TyrusExtension(String name) {
        this(name, null);
    }

    public TyrusExtension(String name, List<Extension.Parameter> parameters) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.parameters = parameters != null ? new ArrayList<Extension.Parameter>(parameters) : new ArrayList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Extension.Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TyrusExtension{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", parameters=").append(this.parameters);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TyrusExtension that = (TyrusExtension)o;
        return this.name.equals(that.name) && this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + this.parameters.hashCode();
        return result2;
    }

    static String toString(Extension extension2) {
        StringBuilder sb = new StringBuilder();
        sb.append(extension2.getName());
        List<Extension.Parameter> extensionParameters = extension2.getParameters();
        if (extensionParameters != null && !extensionParameters.isEmpty()) {
            for (Extension.Parameter p : extensionParameters) {
                sb.append("; ");
                sb.append(TyrusParameter.toString(p));
            }
        }
        return sb.toString();
    }

    public static List<Extension> fromString(List<String> s2) {
        return TyrusExtension.fromHeaders(s2);
    }

    public static List<Extension> fromHeaders(List<String> extensionHeaders) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        if (extensionHeaders == null) {
            return extensions;
        }
        for (String singleHeader : extensionHeaders) {
            if (singleHeader == null) break;
            char[] chars = singleHeader.toCharArray();
            int i = 0;
            ParserState next2 = ParserState.NAME;
            StringBuilder name = new StringBuilder();
            StringBuilder paramName = new StringBuilder();
            StringBuilder paramValue = new StringBuilder();
            ArrayList<Extension.Parameter> params2 = new ArrayList<Extension.Parameter>();
            do {
                block47: {
                    block0 : switch (next2) {
                        case NAME: {
                            switch (chars[i]) {
                                case ';': {
                                    next2 = ParserState.PARAM_NAME;
                                    break block0;
                                }
                                case ',': {
                                    if (name.length() > 0) {
                                        extensions.add(new TyrusExtension(name.toString().trim(), params2));
                                        name = new StringBuilder();
                                        paramName = new StringBuilder();
                                        paramValue = new StringBuilder();
                                        params2.clear();
                                    }
                                    next2 = ParserState.NAME;
                                    break block0;
                                }
                                case '=': {
                                    next2 = ParserState.ERROR;
                                    break block0;
                                }
                            }
                            name.append(chars[i]);
                            break;
                        }
                        case PARAM_NAME: {
                            switch (chars[i]) {
                                case ';': {
                                    next2 = ParserState.PARAM_NAME;
                                    params2.add(new TyrusParameter(paramName.toString().trim(), null));
                                    paramName = new StringBuilder();
                                    paramValue = new StringBuilder();
                                    break block0;
                                }
                                case ',': {
                                    next2 = ParserState.NAME;
                                    params2.add(new TyrusParameter(paramName.toString().trim(), null));
                                    paramName = new StringBuilder();
                                    paramValue = new StringBuilder();
                                    if (name.length() <= 0) break block0;
                                    extensions.add(new TyrusExtension(name.toString().trim(), params2));
                                    name = new StringBuilder();
                                    paramName = new StringBuilder();
                                    paramValue = new StringBuilder();
                                    params2.clear();
                                    break block0;
                                }
                                case '=': {
                                    next2 = ParserState.PARAM_VALUE;
                                    break block0;
                                }
                            }
                            paramName.append(chars[i]);
                            break;
                        }
                        case PARAM_VALUE: {
                            switch (chars[i]) {
                                case '\"': {
                                    if (paramValue.length() > 0) {
                                        next2 = ParserState.ERROR;
                                        break block0;
                                    }
                                    next2 = ParserState.PARAM_VALUE_QUOTED;
                                    break block0;
                                }
                                case ';': {
                                    next2 = ParserState.PARAM_NAME;
                                    params2.add(new TyrusParameter(paramName.toString().trim(), paramValue.toString().trim()));
                                    paramName = new StringBuilder();
                                    paramValue = new StringBuilder();
                                    break block0;
                                }
                                case ',': {
                                    next2 = ParserState.NAME;
                                    params2.add(new TyrusParameter(paramName.toString().trim(), paramValue.toString().trim()));
                                    paramName = new StringBuilder();
                                    paramValue = new StringBuilder();
                                    if (name.length() <= 0) break block0;
                                    extensions.add(new TyrusExtension(name.toString().trim(), params2));
                                    name = new StringBuilder();
                                    paramName = new StringBuilder();
                                    paramValue = new StringBuilder();
                                    params2.clear();
                                    break block0;
                                }
                                case '=': {
                                    next2 = ParserState.ERROR;
                                    break block0;
                                }
                            }
                            paramValue.append(chars[i]);
                            break;
                        }
                        case PARAM_VALUE_QUOTED: {
                            switch (chars[i]) {
                                case '\"': {
                                    next2 = ParserState.PARAM_VALUE_QUOTED_POST;
                                    params2.add(new TyrusParameter(paramName.toString().trim(), paramValue.toString()));
                                    paramName = new StringBuilder();
                                    paramValue = new StringBuilder();
                                    break block0;
                                }
                                case '\\': {
                                    next2 = ParserState.PARAM_VALUE_QUOTED_QP;
                                    break block0;
                                }
                                case '=': {
                                    next2 = ParserState.ERROR;
                                    break block0;
                                }
                            }
                            paramValue.append(chars[i]);
                            break;
                        }
                        case PARAM_VALUE_QUOTED_QP: {
                            next2 = ParserState.PARAM_VALUE_QUOTED;
                            paramValue.append(chars[i]);
                            break;
                        }
                        case PARAM_VALUE_QUOTED_POST: {
                            switch (chars[i]) {
                                case ',': {
                                    next2 = ParserState.NAME;
                                    if (name.length() <= 0) break block0;
                                    extensions.add(new TyrusExtension(name.toString().trim(), params2));
                                    name = new StringBuilder();
                                    paramName = new StringBuilder();
                                    paramValue = new StringBuilder();
                                    params2.clear();
                                    break block0;
                                }
                                case ';': {
                                    next2 = ParserState.PARAM_NAME;
                                    break block0;
                                }
                            }
                            next2 = ParserState.ERROR;
                            break;
                        }
                        case ERROR: {
                            LOGGER.fine(String.format("Error during parsing Extension: %s", name));
                            if (name.length() > 0) {
                                name = new StringBuilder();
                                paramName = new StringBuilder();
                                paramValue = new StringBuilder();
                                params2.clear();
                            }
                            switch (chars[i]) {
                                case ',': {
                                    next2 = ParserState.NAME;
                                    if (name.length() > 0) {
                                        extensions.add(new TyrusExtension(name.toString().trim(), params2));
                                        name = new StringBuilder();
                                        paramName = new StringBuilder();
                                        paramValue = new StringBuilder();
                                        params2.clear();
                                        break block0;
                                    }
                                    break block47;
                                }
                                case ';': {
                                    next2 = ParserState.PARAM_NAME;
                                    break block0;
                                }
                            }
                        }
                    }
                }
            } while (++i < chars.length);
            if (name.length() > 0 && next2 != ParserState.ERROR) {
                if (paramName.length() > 0) {
                    String paramValueString = paramValue.toString();
                    params2.add(new TyrusParameter(paramName.toString().trim(), paramValueString.equals("") ? null : paramValueString));
                }
                extensions.add(new TyrusExtension(name.toString().trim(), params2));
                params2.clear();
                continue;
            }
            LOGGER.fine(String.format("Unable to parse Extension: %s", name));
        }
        return extensions;
    }

    public static class TyrusParameter
    implements Extension.Parameter,
    Serializable {
        private static final long serialVersionUID = -6818457211703933087L;
        private final String name;
        private final String value;

        public TyrusParameter(String name, String value2) {
            this.name = name;
            this.value = value2;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("TyrusParameter{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", value='").append(this.value).append('\'');
            sb.append('}');
            return sb.toString();
        }

        static String toString(Extension.Parameter parameter) {
            StringBuilder sb = new StringBuilder();
            sb.append(parameter.getName());
            String value2 = parameter.getValue();
            if (value2 != null) {
                sb.append('=').append(value2);
            }
            return sb.toString();
        }
    }

    private static enum ParserState {
        NAME,
        PARAM_NAME,
        PARAM_VALUE,
        PARAM_VALUE_QUOTED,
        PARAM_VALUE_QUOTED_POST,
        PARAM_VALUE_QUOTED_QP,
        ERROR;

    }
}

